/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.loot.mixin;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import io.github.fabricators_of_create.porting_lib.loot.extensions.LootPoolBuilderExtension;
import io.github.fabricators_of_create.porting_lib.loot.extensions.LootPoolExtensions;
import java.lang.reflect.Type;
import net.minecraft.class_55;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_55.class})
public class LootPoolMixin
implements LootPoolExtensions {
    @Unique
    private String name;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Mixin(value={class_55.class_57.class})
    public static class LootPoolSerializerMixin {
        @Inject(method={"serialize(Lnet/minecraft/world/level/storage/loot/LootPool;Ljava/lang/reflect/Type;Lcom/google/gson/JsonSerializationContext;)Lcom/google/gson/JsonElement;"}, at={@At(value="INVOKE", target="Lcom/google/gson/JsonObject;add(Ljava/lang/String;Lcom/google/gson/JsonElement;)V", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
        private void serializeName(class_55 pool, Type type, JsonSerializationContext ctx, CallbackInfoReturnable<JsonElement> cir, JsonObject json) {
            String name = pool.getName();
            if (name != null && !name.startsWith("custom#")) {
                json.addProperty("name", name);
            }
        }

        @ModifyReturnValue(method={"deserialize(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Lnet/minecraft/world/level/storage/loot/LootPool;"}, at={@At(value="RETURN")})
        private class_55 deserializeName(class_55 pool, JsonElement element, Type type, JsonDeserializationContext ctx) {
            JsonPrimitive primitive;
            JsonElement name = element.getAsJsonObject().get("name");
            if (name instanceof JsonPrimitive && (primitive = (JsonPrimitive)name).isString()) {
                pool.setName(name.getAsString());
            }
            return pool;
        }
    }

    @Mixin(value={class_55.class_56.class})
    public static class LootPoolBuilderMixin
    implements LootPoolBuilderExtension {
        @Unique
        private String name;

        @Override
        public class_55.class_56 name(String name) {
            this.name = name;
            return (class_55.class_56)this;
        }

        @ModifyReturnValue(method={"build"}, at={@At(value="RETURN")})
        public class_55 setName(class_55 pool) {
            pool.setName(this.name);
            return pool;
        }
    }
}

